let scale = 1;
const tree = document.getElementById("treeRoot");

function zoom(factor) {
  scale = Math.max(0.3, scale + factor); // minimum 0.3x
  tree.style.transform = `scale(${scale})`;
}

document.getElementById("zoomIn").addEventListener("click", () => zoom(0.1));
document.getElementById("zoomOut").addEventListener("click", () => zoom(-0.1));

// Node creation
function createNode(nodeData, parentUsername = null, side = null) {
  const li = document.createElement("li");
  const nodeDiv = document.createElement("div");
  nodeDiv.className = "node";
  const usernameDiv = document.createElement("div");
  usernameDiv.className = "username";

  if(nodeData) {
    nodeDiv.textContent = "👤";
    usernameDiv.textContent = nodeData.username;
    [nodeDiv, usernameDiv].forEach(el => {
      el.addEventListener("click", e => {
        e.stopPropagation();
        fetchSubTree(nodeData.username, li);
      });
    });
  } else {
    nodeDiv.textContent = "➕";
    usernameDiv.textContent = "--[ Add User ]--";
    [nodeDiv, usernameDiv].forEach(el => {
      el.addEventListener("click", e => {
        e.stopPropagation();
        window.location.href = `register.php?parentUsername=${parentUsername}&side=${side}`;
      });
    });
  }

  li.appendChild(nodeDiv);
  li.appendChild(usernameDiv);
  return li;
}

// Fetch subtree
function fetchSubTree(username, parentLi) {
  const xhr = new XMLHttpRequest();
  xhr.open("POST", "fetch_tree", true);
  xhr.setRequestHeader("Content-type","application/x-www-form-urlencoded");
  xhr.onload = function() {
    if(xhr.status === 200) {
      const treeData = JSON.parse(xhr.responseText);
      const existingUL = parentLi.querySelector("ul");
      if(existingUL) parentLi.removeChild(existingUL);
      generateSubTree(parentLi, treeData);
    }
  };
  xhr.send(`username=${encodeURIComponent(username)}`);
}

// Generate 14-node tree
function generateSubTree(parentLi, nodeData) {
  const ul = document.createElement("ul");
  const level1 = [nodeData.left||null, nodeData.right||null];
  level1.forEach((child, i) => {
    const child1 = createNode(child, nodeData.username, i===0?"left":"right");
    if(child) {
      const ul2 = document.createElement("ul");
      const level2 = [child.left||null, child.right||null];
      level2.forEach((child2Node, j) => {
        const child2 = createNode(child2Node, child.username, j===0?"left":"right");
        if(child2Node) {
          const ul3 = document.createElement("ul");
          const level3 = [child2Node.left||null, child2Node.right||null];
          level3.forEach((child3Node, k) => {
            const child3 = createNode(child3Node, child2Node.username, k===0?"left":"right");
            ul3.appendChild(child3);
          });
          child2.appendChild(ul3);
        }
        ul2.appendChild(child2);
      });
      child1.appendChild(ul2);
    }
    ul.appendChild(child1);
  });
  parentLi.appendChild(ul);
}
