<?php
header('Content-Type: application/json');

$year = isset($_GET['year']) ? intval($_GET['year']) : date('Y');

$earnings = array_fill(1, 12, 0);

// Query all earnings for the selected year
$query = "SELECT amount, date FROM nt_bonus_wallet";
$result = mysqli_query($conn, $query);

while ($row = mysqli_fetch_assoc($result)) {
    $amount = (float)$row['amount'];
    $dateStr = $row['date'];

    // Convert to a PHP DateTime object
    $dt = DateTime::createFromFormat('d-m-Y H:i:s', $dateStr);
    if ($dt && $dt->format('Y') == $year) {
        $month = (int)$dt->format('n'); // numeric month 1–12
        $earnings[$month] += $amount;
    }
}

echo json_encode([
    'labels' => ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'],
    'values' => array_values($earnings)
]);
?>